//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help

//Live Coding track

LCTrack {	
	var <>tracknum;
	var <bus; 
	var group, synthgroup, fxgroup;
	var <name, lco;
	
	//GUI
	var nametext, <on, <arm, <vol, <targetvol, <loc;
	var <>currvol, <>tarvol, <>armval, <>onstate; //immediate variables from ui
	
	var <volbus, <onbus; 
	
	var <>owner; 
	
	*new
	{
	arg tracknum=0, tgroup;
	
	^super.new.tracknum_(tracknum).initLCTrack(tgroup);
	}
	
	initLCTrack
	{
	arg tgroup;
	
	bus= Bus.audio(Server.default, 2);
	group=Group.tail(tgroup);
	synthgroup= Group.head(group);
	fxgroup= Group.tail(group);
	 
	volbus= Bus.control(Server.default, 1); 
	onbus= Bus.control(Server.default, 1); 
	 
	Post << [bus.index,volbus.index, onbus.index]<<nl; 
	 
	currvol=0.0; tarvol=0.0;
	armval=0;
	onstate=0;
	}
	
	makeGUI {arg w,y;
		var backcol, frontcol;
		
		//could be classvar of LiveCoding1 class but easiest like this
		backcol= Color.blue(0.7,0.3); //Color.new255(135, 250, 106);  //Color.new255(135, 106, 250);	//135,206,250
		frontcol= Color.white; //Color.new255(150, 40, 70);
		
		arm=SCButton(w, Rect(5,y, 35, 15)).font_(Font.default);
		
		//could have a third state for fade out, same as X for kill/set purposes
		arm.states= [[" ", frontcol, backcol],["X", backcol, frontcol]]; 
		
		arm.action_({armval= arm.value;});
		
		targetvol=SCSlider(w, Rect(50,y, 100, 15)).knobColor_(backcol).background_(backcol);
		
		targetvol.action_({
		tarvol=targetvol.value;});
		
		nametext=SCStaticText(w, Rect(155,y, 100, 20)).string_("nil").font_(Font.default).stringColor_(frontcol);
		
		on=SCButton(w, Rect(255,y, 35, 20)).font_(Font.default);
		
		vol=SCSlider(w, Rect(300,y, 100, 15)).knobColor_(backcol).background_(backcol);
		
		vol.action_({
		this.volfunc(vol.value);
		});
		
		on.states= [["off", frontcol, backcol],["on", backcol, frontcol]]; 
		
		on.action_({
		//could pause if not a clock process
		//"here".postln;
		//if(lco.notNil,{lco.pause(on.value)});
		this.onfunc(on.value);
		
		});
		
		loc=SCButton(w, Rect(405,y, 40, 20)).font_(Font.default);
		
		loc.states= [["code", frontcol, backcol]]; 
		
		loc.action_({
		//if(lco.notNil,{lco.loc.lookup});
		});
		
	}
	
	onfunc { arg state=1;
		
		onstate=state;
		if(lco.notNil,{lco.pause(onstate)});
		
		onbus.set(onstate);
		{on.value_(state)}.defer;
	}
	
	volfunc { arg volume;
		
		currvol=volume;
		volbus.set(volume.squared);
		
		{vol.value_(volume)}.defer;
		}
		
		//to keep costs lower in fade drawing
		volfuncnoGUIupdate { arg volume;
		
		currvol=volume;
		volbus.set(volume.squared);
		
		//{vol.value_(volume)}.defer;
	}
	
	
	saveState {
		^[onstate,currvol]
	}
	
	loadState {arg state;
		
		this.onfunc(state[0]);
		this.volfunc(state[1]);
	}
	
	//free appropriate synth/group
	kill {
		//kill all subgroups and synths
		
		//mute to avoid click from kill
		this.onfunc(0);
		
		if(lco.notNil,
		{
		lco.kill;
		lco=nil;
		synthgroup.freeAll; //only takes sublevel stuff;
		name=nil;
		{nametext.string_("nil");
		
		//no need to change volume
		//vol.value_(0.0); vol.action.value; 
		}.defer;
		});
		
	}
	
	//frees everything
	free {
		//if(lco.notNil,{this.kill});
		
		this.kill;
		
		//not immediate to avoid clashes
		SystemClock.sched(0.1,{
		group.free;	//recrsively all underneath
		bus.free;
		volbus.free;
		onbus.free;
		nil});
		
	}
	
	
	run {arg bool=true;
		
		if(lco.notNil,{lco.run(bool)});
		
	}
	
	
	add {arg l, v, o, tempoclock;
	
	lco=l;
	
	name= l.name;
	//SynthDef(name, {Out.ar(bus.index, func.value)}).play(synthgroup);
	
	onstate=o;
	
	onbus.set(onstate);
	
	//this.onfunc(o); //can't call this directly since lco object not ready yet
	this.volfunc(v);
	
	{
	//vol.action.value; 
	
	//if starting muted call mute func, else do nothing, 
	//assumes all lco objects start in their running state
	//on.value_(o); if(o<0.5, {this.onfunc(o)}); 
	
	
	//vol.value_(v); 
	on.value_(onstate);
	
	nametext.string_((tracknum.asString)+name);
	}.defer;
	
	lco.play(bus.index, synthgroup, tempoclock, tracknum);
	
	//if Synth not created yet, may get this message late- need to sendBundle in this case
	if(lco.notNil,{lco.pause(onstate)});
	
	}
	
	fade {
		arg time=3.0;
		var steps, vols;
		
		//how many steps to schedule? 
		//depends on time- max of 10 per second
		steps= (10*time).asInteger.max(1);
		
		//loagrithmic or linear? Keep linear for now then squaring will sort it out? 
		
		vols= Array.fill(steps, {arg i; 
		var prop;
		
		prop= (i+1)/steps;
		
		(1.0-prop)*currvol+(prop*tarvol);
		});
		
		//SystemClock.sched(0.0, {0.1})
		
		Task({ 
			
			steps.do({ arg i;
					
					//still have to defer even though passed in AppClock to run
					//{vol.value_(vols.at(i)); vol.action.value;}.defer;
					
					this.volfunc(vols[i]);
					
					0.1.wait 
			}); 
		}).start(AppClock.new);
		
	}
	
}